%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%  Please do not edit this file. %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}
\ProvidesPackage{jnma}[2015/04/23 Standard LaTeX document class]
\LoadClass[10pt,twoside]{article}
\ExecuteOptions{article}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\ProcessOptions

\usepackage{amsmath}
\usepackage{amsthm}
\usepackage{amssymb}
\usepackage{graphicx}
\usepackage{cite}
\usepackage{epsfig}
\usepackage[normal]{subfigure}
\usepackage{paralist}
\usepackage{caption2}
\usepackage[colorlinks,linkcolor=black,citecolor=red,urlcolor=blue]{hyperref}
\usepackage{epstopdf}
\usepackage{float}
\usepackage{multirow}
\usepackage{marginnote}
\renewcommand*\marginfont{\normalfont}
\usepackage{longtable}
\usepackage{etoolbox}
\usepackage{geometry}
%\geometry{top=2.5cm}
\usepackage{footmisc}

%\usepackage{background}
%\usepackage{lipsum}
%%\SetWatermarkScale{5}
%%\usepackage[dvipsnames,usenames]{color}
%%\SetBgContents{Author's personal copy}
%\SetBgColor{gray}
%\SetBgAngle{0}
%\SetBgHshift{0}
%\SetBgVshift{106}
%\SetBgScale{3}



\AtEndDocument{\label{enpage}}
\def\lastpage{\pageref{enpage}}
\def\firstpage#1{\gdef\firstpage{#1}\setcounter{page}{#1}}

\def\@maketitle{%
  \vspace*{22pt}%
  \centering
  \linespread{1.15}\selectfont
  {\Large\bfseries\boldmath\@title\par}%        <- ??
  \vspace{18pt}%
  {\large\@author\par}%                         <- ??
  % ========  ????? + ???  =========
\vspace{20pt}
\hbox to \hsize{\centerline{\footnotesize{Received \received; Accepted \accepted}}}

  \vspace{5pt}%
  \hrule height 0.4pt   % ??????
  \vspace{20pt}%
  % =========================================
}

\makeatletter
\patchcmd{\LT@makecaption}%
   {\@tempboxa{#1{#2: }#3}}
   {\@tempboxa{#1{\textbf{#2. }} #3}}{}{}
\patchcmd{\LT@makecaption}%
   {#1{#2: }#3}
   {#1\textbf{#2. }{ #3}}{}{}
\makeatother


 \textwidth 5in \textheight 8.2in \oddsidemargin
15mm \evensidemargin 15mm \headsep 5mm \footskip 8mm

 \doublerulesep
0.3pt \numberwithin{equation}{section} \catcode`@=11
\def\ps@nk{\def\@oddhead{\vbox{\hbox to \hsize{\footnotesize
\footnotesize{\shorttitle \hfill \thepage}} \vspace{1mm} \hrule
\vspace*{-2mm}}}
\def\@evenhead{\vbox{\hbox to \hsize{\footnotesize \footnotesize{\thepage \hfill
\hfill \shortauthor}} \vspace{1mm} \hrule \vspace*{-2mm}}}
\def\@oddfoot{} \def\@evenfoot{}}

\def\ps@first{\def\@oddhead{\vbox{\vspace*{-5mm}
\hbox to \hsize{\footnotesize{Journal of Nonlinear Modeling and Analysis \hfill https://global-sci.com/jnma}} \vspace{1mm}
\hbox to \hsize{\footnotesize{Volume \currentvolume,  Number
\currentissue, \currentmonth\  \currentyear, \thepage--\lastpage \hfill%\doi
\href{http://dx.doi.org/\doi}{DOI:\doi}
}}\vspace{1mm}\hrule \vspace*{-10mm} \break}}
\def\@evenhead{\vbox{\vspace*{-5mm}
\hbox to \hsize{\footnotesize{Journal of Nonlinear Modeling and Analysis \hfill https://global-sci.com/jnma}} \vspace{1mm}
\hbox to \hsize{\footnotesize{Volume \currentvolume,  Number
\currentissue, \currentmonth\  \currentyear, \thepage--\lastpage \hfill %\doi
\href{http://dx.doi.org/\doi}{DOI:\doi}
}} \vspace{1mm}\hrule \vspace*{-10mm} \break} }
\def\@oddfoot{} \def\@evenfoot{}}
\def\Section#1{\Sec{#1} \setcounter{equation}{0} \vspace*{-5mm} \indent}
\def\Sec{\@Startsection{section}{1}{\z@}
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\large\bfseries\boldmath}} % czj
\captionsetup{labelfont={bf}}
\captionsetup{font={scriptsize}}
\renewcommand{\subcapsize}{\scriptsize}
\renewcommand{\@seccntformat}[1]{%
{\csname the#1\endcsname.}\hspace{0.5em}}
\renewcommand{\captionlabeldelim}{.}

\def\@Startsection#1#2#3#4#5#6{%
  \if@noskipsec \leavevmode \fi
  \par
  \@tempskipa #4\relax
  \@afterindenttrue
  \ifdim \@tempskipa <\z@
    \@tempskipa -\@tempskipa \@afterindentfalse
  \fi
  \if@nobreak
    \everypar{}%
  \else
    \addpenalty\@secpenalty\addvspace\@tempskipa
  \fi
  \@ifstar
    {\@ssect{#3}{#4}{#5}{#6}}%
    {\@dblarg{\@Sect{#1}{#2}{#3}{#4}{#5}{#6}}}}
\def\@Sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\large \@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
          \@hangfrom{\hskip #3\relax\@svsec \hskip -1mm}%
          \interlinepenalty \@M #8\@@par}
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}
\def\Subsection#1{\Subsec{#1} \vspace*{-6mm} \indent}
\def\Subsec{\@StartSubsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\bfseries\boldmath}}
\def\@StartSubsection#1#2#3#4#5#6{%
  \if@noskipsec \leavevmode \fi
  \par
  \@tempskipa #4\relax
  \@afterindenttrue
  \ifdim \@tempskipa <\z@
    \@tempskipa -\@tempskipa \@afterindentfalse
  \fi
  \if@nobreak
    \everypar{}%
  \else
    \addpenalty\@secpenalty\addvspace\@tempskipa
  \fi
  \@ifstar
    {\@ssect{#3}{#4}{#5}{#6}}%
    {\@dblarg{\@SubSect{#1}{#2}{#3}{#4}{#5}{#6}}}}
\def\@SubSect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
          \@hangfrom{\hskip #3\relax\@svsec\hskip -1.5mm}%
          \interlinepenalty \@M #8\@@par}
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}
\def\list#1#2{\ifnum \@listdepth >5\relax \@toodeep \else \global
\advance \@listdepth\@ne \fi \rightmargin \z@ \listparindent\z@
\itemindent\z@ \csname @list\romannumeral\the\@listdepth\endcsname
\def\@itemlabel{#1}\let\makelabel\@mklab \@nmbrlistfalse #2\relax
\@trivlist \parskip 0pt \parindent\listparindent \advance \linewidth
-\rightmargin \advance\linewidth -\leftmargin
\advance\@totalleftmargin \leftmargin \parshape \@ne
\@totalleftmargin \linewidth \ignorespaces} \catcode`@=12
\pagestyle{nk}

\renewenvironment{abstract}{ \small \hangafter 0
\hangindent 8.1mm \vskip -4mm
\hsize=0.93\textwidth\def\baselinestretch{1}%
  \noindent\textbf{Abstract}%
\hskip 2.5mm\noindent\ignorespaces}

\newenvironment{keyword}{ \small \hangafter 0
\hangindent 8.1mm \vskip 2mm
\hsize=0.93\textwidth\def\baselinestretch{1}%
  \noindent\textbf{Keywords}%
\hskip 2.5mm\noindent\ignorespaces}

\newenvironment{MSC}{ \small \hangafter 0
\hangindent 8.1mm \vskip 2mm
\hsize=0.93\textwidth\def\baselinestretch{1}%
  \noindent\textbf{MSC(2010)}%
\hskip 2.5mm\noindent\ignorespaces }



\newtheoremstyle{theorem}{6pt}{6pt}{\itshape}{}{\bfseries}{.}{.5em}{}
\newtheoremstyle{definition}{6pt}{6pt}{\upshape}{}{\bfseries}{.}{.5em}{}
\theoremstyle{theorem}
\newtheorem{theorem}{Theorem}[section]
\newtheorem{lemma}{Lemma}[section]
\newtheorem{corollary}{Corollary}[section]
\newtheorem{proposition}{Proposition}[section]
\newtheorem{conjecture}{Conjecture}[section]
\newtheorem{problem}{Problem}[section]
\theoremstyle{definition}
\newtheorem{definition}{Definition}[section]
\newtheorem{example}{Example}[section]
\newtheorem{remark}{Remark}[section]
\newtheorem{notation}{Notation}[section]
\def\proof{\noindent {\bf Proof.}\quad\ignorespaces}
\def\endproof{{\hfill\qed}\par}
\def\thebibliography#1{\vspace*{-3mm}
\section*{\leftline{{\Large  {\normalfont {\bfseries References}}}}}
\list{[\arabic{enumi}]} {\settowidth \labelwidth{[#1]} \leftmargin
\labelwidth \advance \leftmargin \labelsep \usecounter{enumi}}
\def\newblock{\hskip .11em plus .33em minus .07em} \sloppy \clubpenalty
4000 \widowpenalty 4000 \sfcode`\.=1000 \relax}
\newcommand{\topcaption}{%
\setlength{\abovecaptionskip}{0pt}%
\setlength{\belowcaptionskip}{10pt}%
\caption}

\allowdisplaybreaks[4]

\setlength\arraycolsep{1.5pt}
\renewcommand{\arraystretch}{1.5}
\typeout{>>>  jnma.cls  loaded  <<<}
\endinput
